package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.WorkflowType;
import gov.va.vinci.dart.db.WorkflowTypeDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public class WorkflowTypeDAOImpl extends HibernateDAO implements WorkflowTypeDAO {
	
	@Override
	public WorkflowType findById(final int workflowTypeId) throws ObjectNotFoundException {
		Query q = createQuery("from WorkflowType where id=:workflowTypeId");
		q.setParameter("workflowTypeId", workflowTypeId);
		try {
			return (WorkflowType)q.getSingleResult();
		}
		catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
		catch (NonUniqueResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}

	@Override
	public WorkflowType findByName(final String name) throws ObjectNotFoundException {
		
		Query query = createQuery("from WorkflowType where name like :pname");
		query.setParameter("pname", name);
		try {
			return (WorkflowType)query.getSingleResult();
		} catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<WorkflowType> listAll() {
		Query query = createQuery("from WorkflowType");
		return (List<WorkflowType>)query.getResultList();
	}
}
